<?php
namespace App\Http\Resources;

use Illuminate\Http\Resources\Json\JsonResource;
use Illuminate\Support\Facades\DB;

class NoteResource extends JsonResource
{
    public function toArray($request)
    {

        if($this->type == 'orders'){

//            $orders =  DB::table('orders')
//                ->where('order_id',$this->item_id)
//                ->get();
//            $ordersResource = OrderResource::collection($orders);
//            return $ordersResource;


            $order = DB::table('orders')
                ->select(
                    'order_uniq_id', 'created','status','shpr_name','shpr_number','shpr_email','car_year','car_make', 'car_model', 'source',
                    'pickup_city','pickup_state','pickup_zip','delivery_city','delivery_state','delivery_zip'
                )
                ->where('order_id',$this->item_id)->first();

            $uuid = $order->order_uniq_id;
            $sub_title = "From: " . $order->pickup_city . ', ' . $order->pickup_state . ', ' .$order->pickup_zip .  ' To: ' . $order->delivery_city . ', ' . $order->delivery_state . ', ' . $order->delivery_zip;
            $status = $order->status;
            $contact = $order->shpr_name;
            $mobile = $order->shpr_number;
            $email =  $order->shpr_email;
            $load =   $order->car_year  . ' ' . $order->car_make . ' ' .  $order->car_model;
            $created = $order->created;
            $source = $order->source;

            return [
                'table_name' => 'notes',
                'id' => $this->note_id,
                'uuid' => $uuid,
                'type' => $this->type,
                'title' => $this->note,
                'sub_title' => $sub_title,
                'status' =>  $status,
                'contact' => $contact,
                'mobile' => $mobile,
                'email' =>  $email,
                'load' => $load,
                'created' => $created,
                'source' => $source,
//            'sub_title' => "Author:".  $this->added_by,
            ];

        } else if($this->type == 'quotes'){

//            $quotes =  DB::table('quotes')
//                ->where('quote_id',$this->item_id)
//                ->get();
//            $quotesResource = QuoteResource::collection($quotes);
//            return $quotesResource;


            $quote = DB::table('quotes')
                ->select('quote_uniq_id', 'quoted','shpr_name','shpr_number','shpr_email','car_year','car_make', 'car_model','source',
                    'origin_city', 'origin_state', 'origin_zip','dest_city','dest_state','dest_zip'
                )
                ->where('quote_id',$this->item_id)->first();

            $uuid = '123';//$quote->quote_uniq_id;
            $sub_title = "From: " . $quote->origin_city . ', ' . $quote->origin_state . ', ' .$quote->origin_zip .  ' To: ' . $quote->dest_city . ', ' . $quote->dest_state . ', ' . $quote->dest_zip;
            $status = 'Quote';
            $contact = $quote->shpr_name;
            $mobile = $quote->shpr_number;
            $email =  $quote->shpr_email;
            $load =   $quote->car_year  . ' ' . $quote->car_make . ' ' .  $quote->car_model;
            $created = $quote->created;
            $source = $quote->source;

            return [
                'table_name' => 'notes',
                'id' => $this->note_id,
                'uuid' => $uuid,
                'type' => $this->type,
                'title' => $this->note,
                'sub_title' => $sub_title,
                'status' =>  $status,
                'contact' => $contact,
                'mobile' => $mobile,
                'email' =>  $email,
                'load' => $load,
                'created' => $created,
                'source' => $source,
//            'sub_title' => "Author:".  $this->added_by,
            ];
        } else {
            return [];
        }


    }
}

//            'object_id' => $this->item_id,
//            'item_id' => $this->item_id,
//            'note_type' => $this->note_type,


//            'table_name' => 'orders',
//            'id' => $this->order_id,
//            'uuid' => $this->order_uniq_id,
//            'title' =>  "From: " . $this->pickup_city . ', ' . $this->pickup_state . ', ' .$this->pickup_zip .  ' To: ' . $this->delivery_city . ', ' . $this->delivery_state . ', ' . $this->delivery_zip,
//            'sub_title' => $this->shpr_name . ' ' . $this->shpr_email . ' ' . $this->shpr_mobile ,
//            'status' =>  $this->status,
//            'contact' => $this->shpr_name,
//            'mobile' => $this->shpr_number,
//            'email' =>  $this->shpr_email ,
//            'load' =>   $this->car_year  . ' ' . $this->car_make . ' ' .  $this->car_model,
//            'created' => $this->created,
//            'source' => $this->source,

//            'table_name' => 'quotes',
//            'id' => $this->quote_id,
//            'object_id' => $this->quote_uniq_id,
//            'title' => "From: " . $this->origin_city . ', ' . $this->origin_state . ', ' .$this->origin_zip .  ' To: ' . $this->dest_city . ', ' . $this->dest_state . ', ' . $this->dest_zip,
//            'sub_title' => $this->shpr_name . ' ' . $this->shpr_email . ' ' . $this->shpr_number,
//            'status' => "Quote",
//            'contact' => $this->shpr_name,
//            'mobile' => $this->shpr_number,
//            'email' => $this->shpr_email,
//            'load' => $this->car_year  . ' ' . $this->car_make . ' ' .  $this->car_model,
//            'created' => $this->quoted,
//            'source' => $this->source,
