<head>
    <!-- 1: References the Square payment library to initalize the SDK -->
    <script src="https://sandbox.web.squarecdn.com/v1/square.js"></script>
    <!-- 2: jQuery Core 3.6.1 Minified -->
    <script src="https://code.jquery.com/jquery-3.6.1.min.js" integrity="sha256-o88AwQnZB+VDvE9tvIXrMQaPlFFSUTR+nldQm1LuPXQ=" crossorigin="anonymous"></script>

</head>
<body>
<form id="payment-form">
    <div id="card-container"></div>
    <button id="card-button" type="button">Pay</button>
</form>
<!-- Configure the Web Payments SDK and Card payment method -->
<script type="text/javascript">

    const APPLICATION_ID = 'sandbox-sq0idb-SsXJsiJrsbdOgBDh0U0GcQ';
    const LOCATION_ID = 'LH6ZFT98BNFZW';
//CREATE UUID
    function uuidv4() {
        return ([1e7]+-1e3+-4e3+-8e3+-1e11).replace(/[018]/g, c =>
            (c ^ crypto.getRandomValues(new Uint8Array(1))[0] & 15 >> c / 4).toString(16)
        );
    }
    console.log(uuidv4());
    //END CREATE UUID


    async function main() {
        const payments = Square.payments(APPLICATION_ID, LOCATION_ID);
        const card = await payments.card();
        await card.attach('#card-container');

        async function eventHandler(event) {
            event.preventDefault();

            try {
                const result = await card.tokenize();
                if (result.status === 'OK') {
                    console.log(`Payment token is ${result.token}`);

                    //START AJAX
                    var form = new FormData();
                    form.append("paymentID", "paymentID");
                    form.append("key", "key");

                    var settings = {
                        "url": "http://localhost:8888/oauth/create_payment.php",
                        "method": "GET",
                        "timeout": 0,
                        "processData": false,
                        "mimeType": "multipart/form-data",
                        "contentType": false,
                        "data": form
                    };

                    $.ajax(settings).done(function (response) {
                        console.log(response);
                    });
                    //END AJAX
                }
            } catch (e) {
                console.error(e);
            }
        };

        const cardButton = document.getElementById('card-button');
        cardButton.addEventListener('click', eventHandler);
    }

    main();




</script>
</body>
