<?php

namespace App\Http\Resources;

use Illuminate\Http\Request;
use Illuminate\Http\Resources\Json\JsonResource;

class CompanyAccountResource extends JsonResource
{
    /**
     * Transform the resource into an array.
     *
     * @return array<string, mixed>
     */
    public function toArray(Request $request): array
    {
                        if(isset($this->company_name)) {
                            $title = $this->company_name;
                            $contact = $this->company_name;
                        } else {
                            $title = $this->firstname . ' ' . $this->lastname;
                            $contact = $this->firstname . ' ' . $this->lastname;
                        }


        return [
                        'table_name' =>'company_accounts',
                        'id' => $this->comp_account_id,
                        'object_id' => $this->comp_accnt_unique_id,
                        'type' => $this->account_type,
                        'mobile' => $this->phone_1,
                        'title' => $title,
                        'contact' => $contact,
                        'sub_title' => $this->account_type,
        ];
    }
}


//                        $row->table_name = 'company_accounts';
//                        $row->id = $row->comp_account_id;
//                        $row->object_id = $row->comp_accnt_unique_id;
//                        $row->type = $row->account_type;
//                        $row->mobile = $row->phone_1;
//                        if(isset($row->company_name)) {
//                            $row->title = $row->company_name;
//                            $row->contact = $row->company_name;
//                        } else {
//                            $row->title = $row->firstname . ' ' . $row->lastname;
//                            $row->contact = $row->firstname . ' ' . $row->lastname;
//                        }
//                        $row->sub_title = $row->account_type;

//        return parent::toArray($request);
